<?php 
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */
    
    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    include "../../../classi/ecommerce/Prodotto.php";
    include "../../../gUtil/GestoreTabella.php";
    include "../../../classi/Tabella.php";
        
    if(isset($_GET["id"])) {
        $ordine = $geecomDb->leggiSingolaRiga("geecEc_ordini",filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT));
        $dataRegistrazione = date("d/m/Y",strtotime($ordine["dataOrdine"]));
    }
    
    $datiGeecomAdmin   = $geecomDb->leggiSingolaRiga("geec_prodotti",2);
    $impostazioniAdmin = $geecomDb->leggiSingolaRiga("geecAd_impostazioni",1);
    $linkGeecomAdmin   = GeneratoreUrl::creaUrlAreaAmministrativa($impostazioniAdmin, $datiGeecomAdmin);
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Componente e-commerce -dettagli ordine</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>
	
        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">

                <?php 
                    if(isset($_GET["status"])) {
                        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
                    }
                    else {
                        $status = 0;
                    }

                ?>
                <form name="formProdotto" action="../../../controller/controllerElementi.php" method="post">
                    <input type="text" class="d-none" name="operazione" value="<?php echo((isset($ordine) ? "modifica" : "crea")); ?>">
                    <input type="text" class="d-none" name="id" value="<?php echo((isset($ordine) ? $ordine["id"] : "0")); ?>">
                    
                    <div class="row py-4">
                        <?php 
                            if($status==300) {
                                echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Elemento modificato
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                            else if($status==370) {
                                 echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Elemento duplicato nel nuovo portfolio
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                        ?>
                        <input type="text" class="d-none" id="operazione" value="modifica">

                        <div class="col-12 ">
                            <div class="form-row mb-3">
                                <div class="col-md-7 d-flex">
                                    <nav aria-label="breadcrumb" class="align-self-center">
                                        <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                            <li class="breadcrumb-item"><a href="home.php">Home</a></li>
                                            <li class="breadcrumb-item"><a href="home.php">Componenti</a></li>
                                            <li class="breadcrumb-item"><a href="index.php">E-commerce</a></li>
                                            <li class="breadcrumb-item"><a href="index.php?status=230">Ordini</a></li>
                                            <li class="breadcrumb-item active" aria-current="page"><?= $ordine["id"] ?></li>
                                        </ol>
                                    </nav>
                                </div>
                                <div class="col-md-5 text-right">
                                    <a class="btn btn-primary mr-1" href="creaOrdine.php">Crea nuovo<i class="fas fa-plus ml-2"></i></a>
                                    <a class="btn btn-outline-primary mr-1" href="stampaOrdine.php?id=<?= $ordine["id"] ?>">Stampa<i class="fas fa-print ml-2"></i></a>
                                    <a class="btn btn-outline-primary" href="index.php?status=230"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                </div>
                            </div>

                            
                                    <div class="row">
                                        <div class="col-lg-6 col-xl-5">
                                            <div class="card mb-4 box-shadow-lite">
                                                <div class="card-header">
                                                    <h5 class="mb-0"> Dettagli ordine n. <?= $ordine["id"] ?></h5>
                                                </div>
                                                <div class="card-body">
                                                    <form action="">

                                                        <div class="form-group row">
                                                            <label  class="col-sm-4 col-form-label"><b>Data registrazione</b></label>
                                                            <div class="col-sm-8 d-flex">
                                                                <span class="align-self-center"><?= $dataRegistrazione ?></span>
                                                            </div>
                                                        </div>

                                                        <div class="form-group row">
                                                            <label  class="col-sm-4 col-form-label"><b>Ordinante</b></label>
                                                            <div class="col-sm-8 d-flex">
                                                            <?php
                                                               if($ordine["idCliente"]!=0) {
                                                                   echo"<span class=\"align-self-center\"><b><a href=\"$linkGeecomAdmin/creaUtente.php?id={$ordine["idCliente"]}\">{$ordine["destinatario"]}</a></b></span>";
                                                               }
                                                               else {
                                                                   echo"<span class=\"align-self-center\"><b>{$ordine["destinatario"]} </b>(non registrato)</span>";
                                                               }
                                                            ?>
                                                            </div>
                                                        </div>

                                                        <div class="form-group row">
                                                            <label  class="col-sm-4 col-form-label"><b>Metodo pagamento</b></label>
                                                            <div class="col-sm-8 d-flex">
                                                                <span class="align-self-center mr-2"><?= $ordine["tipoPagamento"] ?></span>
                                                                <?php
                                                                    if($ordine["tipoPagamento"]=="stripe") {
                                                                        echo"<span class=\"align-self-center\">(id transazione: {$ordine["idTransazione"]})</span>";
                                                                    }
                                                                ?>
                                                            </div>
                                                        </div>

                                                        <div class="form-group row">
                                                            <label  class="col-sm-4 col-form-label"><b>Stato</b></label>
                                                            <div class="col-sm-8">
                                                                <select name="stato" id="stato" class="form-control">
                                                                    <?php 
                                                                        $statiOrdine = array("in attesa di pagamento","pagato","spedito","rimborsato","stornato","annullato");
                                                                        foreach($statiOrdine as $stato) {
                                                                            if($stato==$ordine["stato"]) {
                                                                                echo"<option value=\"$stato\" selected>$stato</option>";
                                                                            }
                                                                            else {
                                                                                echo"<option value=\"$stato\">$stato</option>";
                                                                            }
                                                                        }
                                                                    ?>
                                                                </select>
                                                            </div>
                                                        </div>

                                                        <div class="form-group row">
                                                            <label  class="col-sm-4 col-form-label"><b>Tipo di spedizione</b></label>
                                                            <div class="col-sm-8 d-flex">
                                                                <span class="align-self-center"><?= $ordine["tipoSpedizione"] ?></span>
                                                            </div>
                                                        </div>

                                                        <div class="form-group row">
                                                            <label  class="col-sm-4 col-form-label"><b>Codice tracciamento</b></label>
                                                            <div class="col-sm-8">
                                                                <input type="text" class="form-control" id="codiceTracciamento" name="codiceTracciamento" value="<?= $ordine["codiceTracciamento"] ?>">
                                                            </div>
                                                        </div>

                                                        <div class="form-group row">
                                                            <label  class="col-sm-4 col-form-label"><b>Indirizzo di spedizione</b></label>
                                                            <div class="col-sm-8 d-flex">
                                                                <span class="align-self-center"><?php echo "{$ordine["indirizzoSpedizione"]}, {$ordine["citta"]}, {$ordine["capSpedizione"]}" ?></span>
                                                            </div>
                                                        </div>

                                                        <div class="form-group row">
                                                            <label  class="col-sm-4 col-form-label"><b>Email</b></label>
                                                            <div class="col-sm-8 d-flex">
                                                              <span class="align-self-center"><?= $ordine["email"] ?></span>
                                                            </div>
                                                        </div>

                                                        <div class="form-group row">
                                                            <label  class="col-sm-4 col-form-label"><b>Telefono</b></label>
                                                            <div class="col-sm-8 d-flex">
                                                              <span class="align-self-center"><?= $ordine["telefono"] ?></span>
                                                            </div>
                                                        </div>

                                                        <div class="form-group row">
                                                            <label  class="col-sm-4 col-form-label"><b>Importo €</b></label>
                                                            <div class="col-sm-8 d-flex">
                                                                <span class="align-self-center"><?= $ordine["importoTotaleOrdine"] ?></span>
                                                            </div>
                                                        </div>

                                                        <div class="form-group row">
                                                            <label  class="col-sm-4 col-form-label"><b>Codice fiscale</b></label>
                                                            <div class="col-sm-8 d-flex">
                                                                <span class="align-self-center"><?= $ordine["codiceFiscale"] ?></span>
                                                            </div>
                                                        </div>

                                                        <div class="form-group row">
                                                            <label  class="col-sm-4 col-form-label"><b>Partita IVA</b></label>
                                                            <div class="col-sm-8 d-flex">
                                                                <span class="align-self-center"><?= $ordine["partitaIva"] ?></span>
                                                            </div>
                                                        </div>
                                                        
                                                        <div class="form-group row">
                                                            <label  class="col-sm-4 col-form-label"><b>Tipo ricevuta</b></label>
                                                            <div class="col-sm-8 d-flex">
                                                                <span class="align-self-center"><?= $ordine["tipoRicevuta"] ?></span>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                                <div class="card-footer">
                                                    <button type="button" class="btn btn-primary float-right btn-sm" onclick="aggiornaOrdine()"><i class="fas fa-check"></i> Salva</button>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div id="divElencoElementi" class="col-lg-6 col-xl-7">
                                            <div class="card mb-4 box-shadow-lite">
                                                <div class="card-body">
                                                    <?php
                                                        $parametri = array("tabella"=>"geecEc_prodottiOrdinati", "elementiPerPagina"=>25,"parametriRicerca"=>array("idCarrello"=>$ordine["idCarrello"]),"ajax"=>false);

                                                        $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"gestioneUtenti.php");
                                                        
                                                        if(isset($_GET["pag"])) {
                                                            $ris = $ricerca->eseguiRicerca($_GET["pag"]);
                                                        }
                                                        else {
                                                            $ris = $ricerca->eseguiRicerca(1);
                                                        }

                                                        $colonne = array("Oggetto","Quantità","Costo unitario");
                                                        $tabella = new Tabella("tabella", "table table-striped table-hover",$colonne);
                                                        $tabella->setTipo("normale");
                                                        while($prodottoOrdinato = $ris->fetch_assoc()) {
                                                            $stringaAttributoProdotto = ($prodottoOrdinato["attributo"]!="") ? "<br>".$prodottoOrdinato["attributo"] : "";
                                                            $tabella->aggiungiNuovaRiga(array("<a href=\"creaProdotto.php?id={$prodottoOrdinato["idProdotto"]}\"><b>{$prodottoOrdinato["nomeProdotto"]}</b></a>$stringaAttributoProdotto",$prodottoOrdinato["quantita"],$prodottoOrdinato["prezzoUnitario"]),array());;
                                                        }
                                                        $tabella->stampa();
                                                        $ricerca->stampaPaginazione(true,"dettagliOrdine.php?id={$ordine["id"]}");
                                                    ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                            </div>
                        </div>
                        
                        <!-- Colonna principale -->
                </div>

            </div>
        </main>

        <?php 
            include "../../include/footer.php";

            include "../include/modal/cambiaPassword.php";

            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";
        ?>
            <div class="modal fade" id="modalEliminaImmagine" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Eliminare l'immagine?</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                            <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="d-flex flex-row justify-content-center">
                                <img id="percorsoImmagineDaEliminare" class="img-fluid" src="">
                            </div>
                            <input type="text" class="d-none" id="idImmagineDaEliminare">
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                            <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneOccorrenzaImmagine('../../../')"><i class="fas fa-check"></i> Elimina</button>
                        </div>
                    </div>
                </div>
            </div>
        <?php
            include "../include/jsBaseComponenti.php";
        ?>
        
        <script>
            
            function aggiornaOrdine() {
                var codiceTracciamento = document.getElementById("codiceTracciamento").value;
                var stato              = document.getElementById("stato").value;
                
                $.ajax({
                    type:"POST",
                    url:"../../../controller/ecommerce/controllerOrdini.php",
                    data:{
                        operazione:"modifica",
                        id:<?= $ordine["id"] ?>,
                        stato:stato,
                        codiceTracciamento:codiceTracciamento
                    },
                    success:function() {
                        document.getElementById("labelOperazioneCompletata").innerHTML = "Ordine aggiornato";
                        $('#modalOperazioneCompletata').modal('show');
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }

        </script>
    </body>
</html>
